-- CVN-77 George H. W. Bush (NIMITZ Class Carrier) Current VFA-113 / CVN-70

GT = {};
dofile(current_mod_path..'/CVN_77_BushRunwaysAndRoutes.lua')
GT_t.ws = 0;

set_recursive_metatable(GT, GT_t.generic_ship)

GT.visual = {}
GT.visual.shape = "CVN_77_Bush"
GT.visual.shape_dstr = ""

GT.animation_arguments.radar1_rotation = 11; 
GT.animation_arguments.luna_lights = 100;

GT.life = 7300;
GT.mass = 7.2916e+007;
GT.max_velocity = 15.4333;
GT.race_velocity = 15.4333;
GT.economy_velocity = 15.4333;
GT.economy_distance = 7.408e+007;
GT.race_distance = 7.408e+007;
GT.shipLength = 311.0;
GT.Width = 96;
GT.Height = 57.8;
GT.Length = 332.9;
GT.DeckLevel = 19.6;
GT.X_nose = 150.7;
GT.X_tail = -159.6;
GT.Tail_Width = 18;
GT.Gamma_max = 0.35;
GT.Om = 0.02;
GT.speedup = 0.119249;
GT.R_min = 665.8;
GT.distFindObstacles = 1048.7;
GT.TACAN = true;
GT.TACAN_position = {-55.0, 55.0, 29.0}
GT.ICLS = true;
GT.ICLS_Localizer_position = {-153.0, 12.0, 9.4, 189.0}	-- {x [m], y [m], z [m], yaw [deg]}
GT.ICLS_Glideslope_position = {-79.0, 26.5, 32.7, 3.5}	-- {x [m], y [m], z [m], glideslope = 3.5 [deg]}
GT.OLS = {Type = GT_t.OLS_TYPE.IFLOLS, CutLightsArg = 404, DatumAndWaveOffLightsArg = 405, MeatBallArg = 151, GlideslopeBasicAngle = 3.5, VerticalCoverageAngle = 1.7}

GT.numParking = 4;
GT.Plane_Num_ = 72;
GT.Helicopter_Num_ = 6;

GT.animation_arguments.water_propeller = -1;

GT.airWeaponDist = 15000;
GT.airFindDist = 30000;
-- weapon systems

--GT.LSOView = {cockpit = "empty", position = {--[[connector = "",]] offset = {-14.0, 19.7, -16.0, -171.0, 4.0}}}

--Dummy CAMERA
GT.LSOView = {cockpit = "empty", position = {connector = "PLAT_CAMERA" ,offset = {0.0, 0.0, 0.0, 0.0, 0.0}}} -- 4grad PLAT_CAMERA
--GT.LSOView = {cockpit = "empty", position = {connector = "LSO_PLATFORM" ,offset = {0.0, 0.0, 0.0, 0.0, 0.0}}} --LSO_PLATFORM
--GT.LSOView = {cockpit = "empty", position = {connector = "PRI_FLY" ,offset = {0.0, 0.0, 0.0, 0.0, 0.0}}}--PRI_FLY
--GT.LSOView = {cockpit = "empty", position = {connector = "CAMERA_010" ,offset = {0.0, 0.0, 0.0, 0.0, 0.0}}}--CAMERA_001 to CAMERA_012



GT.Landing_Point = {-104.0, 19.6, -33.0}
GT.animation_arguments.arresting_wires = {400, 401, 402, 403}
GT.animation_arguments.catapult_shuttles = {145, 146, 147, 148}
--GT.animation_arguments.landing_strip_illumination = 150;

GT.animation_arguments.elevators = {57, 58, 59, 60};--lift
GT.animation_arguments.elevators_doors = {47, 48, 53, 54};--tuere

GT.WS = {}
GT.WS.maxTargetDetectionRange = 30000;
GT.WS.radar_type = 104
GT.WS.searchRadarMaxElevation = math.rad(50);

local ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.phalanx )
GT.WS[ws].angles_mech = {
							{math.rad(95), math.rad(-95), math.rad(-5), math.rad(90)}
}
GT.WS[ws].angles[1][1] = math.rad(70);
GT.WS[ws].angles[1][2] = math.rad(-95);
GT.WS[ws].angles[2] = {math.rad(95), math.rad(70), math.rad(10), math.rad(85)};
GT.WS[ws].board = 3
GT.WS[ws].pos = {101.963,17.463,-21.153}
--GT.WS[ws].drawArgument1 = 23
--GT.WS[ws].drawArgument2 = 24

ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.phalanx )
GT.WS[ws].angles_mech = {
							{math.rad(85), math.rad(-70), math.rad(-5), math.rad(90)}
}
GT.WS[ws].angles[1][1] = math.rad(85);
GT.WS[ws].angles[1][2] = math.rad(-45);
GT.WS[ws].angles[2] = {math.rad(-45), math.rad(-70), math.rad(10), math.rad(85)};
GT.WS[ws].board = 4
GT.WS[ws].pos = {90.953,16.097,23.294}
--GT.WS[ws].drawArgument1 = 25
--GT.WS[ws].drawArgument2 = 26

ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.phalanx )
GT.WS[ws].angles[1][1] = math.rad(100);
GT.WS[ws].angles[1][2] = math.rad(-100);
GT.WS[ws].board = 2
GT.WS[ws].pos = {-163.792,10.061,14.483}
--GT.WS[ws].drawArgument1 = 29
--GT.WS[ws].drawArgument2 = 30

ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.phalanx )
GT.WS[ws].angles[1][1] = math.rad(95);
GT.WS[ws].angles[1][2] =  math.rad(-70);
GT.WS[ws].board = 3
GT.WS[ws].pos = {-158.042,10.061,-17.74}
--GT.WS[ws].drawArgument1 = 27
--GT.WS[ws].drawArgument2 = 28

--forward
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.seasparrow )
GT.WS[ws].newZ = GT_t.ANGLE_Z_TRANSLATION_OPTIONS.TRANSLATE_MIN_ANGLE_TO_MINUS_ONE;
GT.WS[ws].pos = {98.225,17.196,21.628}
GT.WS[ws].angles_mech = {
							{math.rad(180), math.rad(-180), math.rad(-5), math.rad(95)}
}
GT.WS[ws].angles[1][1] = math.rad(10);
GT.WS[ws].angles[1][2] = math.rad(-120);
GT.WS[ws].angles[2] = {math.rad(-120), math.rad(10), math.rad(40), 1.48353};
GT.WS[ws].drawArgument1 = 21
GT.WS[ws].drawArgument2 = 22
GT.WS[ws].LN[1].min_launch_angle = math.rad(15);

--back left
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.seasparrow )
GT.WS[ws].board = 3
GT.WS[ws].pos = {-151.36,18.035,-18.969}
GT.WS[ws].newZ = GT_t.ANGLE_Z_TRANSLATION_OPTIONS.TRANSLATE_MIN_ANGLE_TO_MINUS_ONE;
GT.WS[ws].angles_mech = {
							{math.rad(90), math.rad(-90), math.rad(-5), math.rad(95)}
}
GT.WS[ws].angles[1][1] = math.rad(90);
GT.WS[ws].angles[1][2] = math.rad(-65);
GT.WS[ws].angles[2] = {math.rad(-65), math.rad(-90), math.rad(20), 1.48353};
GT.WS[ws].drawArgument1 = 17
GT.WS[ws].drawArgument2 = 18
GT.WS[ws].LN[1].min_launch_angle = math.rad(15);

--back right
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.seasparrow )
GT.WS[ws].board = 4
GT.WS[ws].pos = {-151.36,18.035,25.376}
GT.WS[ws].newZ = GT_t.ANGLE_Z_TRANSLATION_OPTIONS.TRANSLATE_MIN_ANGLE_TO_MINUS_ONE;
GT.WS[ws].angles_mech = {
							{math.rad(90), math.rad(-90), math.rad(-5), math.rad(95)}
}
GT.WS[ws].angles[1][1] = math.rad(70);
GT.WS[ws].angles[1][2] = math.rad(-90);
GT.WS[ws].drawArgument1 = 19
GT.WS[ws].drawArgument2 = 20
GT.WS[ws].LN[1].min_launch_angle = math.rad(15);

GT.Name = "Bush"
GT.DisplayName = _("CVN-77 George H. W. Bush")
GT.Rate = 5500.000000

GT.Sensors = {  OPTIC = {"long-range naval optics", "long-range naval LLTV"},
                RADAR = {
                    "seasparrow tr",
                    "carrier search radar",
                },
            };

GT.DetectionRange  = GT.airFindDist;
GT.ThreatRange 	= GT.airWeaponDist;
GT.Singleton   	="yes";
GT.mapclasskey 	= "P0091000065";
GT.attribute	= {wsType_Navy, wsType_Ship, wsType_AirCarrier, WSTYPE_PLACEHOLDER,
                    "Aircraft Carriers",
                    "Arresting Gear","catapult",
                    "RADAR_BAND1_FOR_ARM",
                    "RADAR_BAND2_FOR_ARM",
				};
GT.Categories = {
					{name = "AircraftCarrier"},
					{name = "AircraftCarrier With Catapult"},
					{name = "Armed Ship"}
				};
--GT.Countries		= {"USA"}
				
add_surface_unit(GT)		


local deck_crew_names = {
				"VP-FIRE_EX",
				"cvn_77_kran",
				"cvn_a-s32a-31a",
				"cvn_a-s32a-31a-fire",
				"cvn_msu-200nav",
				"cvn_gabelstapler",
				"cvn_holdbackbar","cvn_holdbackbar","cvn_holdbackbar",
				"cvn_towbar_zu",
				"vpc-nato-man 1","vpc-nato-man 1","vpc-nato-man 1","vpc-nato-man 1","vpc-nato-man 1","vpc-nato-man 1",
				"vpc-nato-man 1","vpc-nato-man 1","vpc-nato-man 1","vpc-nato-man 1","vpc-nato-man 1","vpc-nato-man 1","vpc-nato-man 1",
				"vpc-nato-man 4",
				"pilot_uh1_01","pilot_uh1_01",
				"cart_mk83_3",
				"cart_gbu10_1",
				"oxygen_cart2",
				"vpc-nato-aim-9m cart",
				"ammo_box_cargo",				
			}
local deck_crew_points = {
{-89.45,19.6,32.01},--kran
{-55,19.6,30},--truck
{-70,19.6,25},--firetruck
{-80,19.6,24},--airtruck
{-88.45,19.6,27.01},--gabelstapler
{55,19.6,5.6},{55,19.6,5.2},{-40,19.6,-25},--holdback
{42,19.6,7},--towbar
{-145.6,19.5,-20.4},{-146.2,19.5,-20.7},{-145.2,19.5,-22.8},{-143.3,19.5,-23.2},{-143.7,19.5,-22.1},{-143.5,19.5,-20.4},--lso1
{65.6,19.6,5.4},{62.6,19.6,4.9},{66,19.6,5.9},{65.6,19.6,6},{67,19.6,5.4},{65,19.6,5},{100,17.9,-18.6},--cat1
{-72,29.2,28.1},--is1and4
{-73.2,31.8,28.3},{-74.6,31.8,28.3},--is1andPilotUH1
{-77.1,19.6,30.4},--cart3 mk83
{-119,19.6,29},--cart1 gbu10
{-118.6,19.6,33,2},--oxycart
{-120,19.6,25},--AIM9cart
{-155.5,19.6,26},--ammo
{-81,19.6,27.9},--fireex
}
GT.deck_crew = {}
local shapes_size = #deck_crew_names
for i,pnt in ipairs(deck_crew_points) do
	GT.deck_crew[i] = 
	{
		pos   = pnt,
		shape = deck_crew_names[math.fmod (i,shapes_size) + 1]
	}
end